/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.vpn;

import ibm.nways.vpn.VpnAllDevicePanel;
import ibm.nways.vpn.VpnDevice;
import ibm.nways.vpn.VpnListJMA;
import ibm.nways.vpn.VpnListModel;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class VpnDeviceList {
    private Vector devices;
    private VpnListModel model;
    private Vector panels = new Vector();
    VpnListJMA browser;
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.vpn.GeneralResources");
    private static ResourceBundle commonResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.CommonFolderGroupResources");
    private static final int UNKNOWN = 0;
    private static final int BEGIN = 1;
    private static final int MIDDLE = 2;
    private static final int END = 3;
    private static final int WHOLE = 4;
    private static final int INVALID = 5;
    public static final int Find_Unknown = -1;
    public static final int Find_NameNotFound = -2;
    public static final int Find_IpNotFound = -3;
    public static final int Find_NameAndIpNotFound = -4;
    public static final int Find_NoSearchDone = -5;
    public static final int Find_NameInvalid = -6;
    public static final int Find_IpInvalid = -7;
    String test = " ";
    public static final int Reset_ALL = 1;
    public static final int Reset_TABLE = 2;
    private String wildcard = "*";

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String string) {
        this.wildcard = string;
    }

    public VpnDeviceList(VpnListModel vpnListModel, VpnListJMA vpnListJMA) {
        this.devices = new Vector();
        this.model = vpnListModel;
        this.browser = vpnListJMA;
        this.initVpnList();
    }

    public Object getContext() {
        return null;
    }

    public void initVpnList() {
        try {
            this.devices = this.model.getDeviceList();
            this.browser.refreshVpnChangeIcon();
            return;
        }
        catch (Exception exception) {
            System.out.println("VpnDeviceList: unable to get list from server");
            return;
        }
    }

    public void resetVpnList() {
        this.initVpnList();
        this.resetAll();
    }

    public synchronized void addPanel(VpnAllDevicePanel vpnAllDevicePanel) {
        if (this.panels != null && !this.panels.contains(vpnAllDevicePanel)) {
            this.panels.addElement(vpnAllDevicePanel);
        }
    }

    public synchronized void removePanel(VpnAllDevicePanel vpnAllDevicePanel) {
        if (this.panels != null) {
            this.panels.removeElement(vpnAllDevicePanel);
        }
    }

    public synchronized void resetRest(VpnAllDevicePanel vpnAllDevicePanel) {
        try {
            int n = 0;
            while (n < this.panels.size()) {
                VpnAllDevicePanel vpnAllDevicePanel2 = (VpnAllDevicePanel)this.panels.elementAt(n);
                if (vpnAllDevicePanel2 != vpnAllDevicePanel) {
                    try {
                        vpnAllDevicePanel2.getLocationOnScreen();
                    }
                    catch (Exception exception) {
                        this.removePanel(vpnAllDevicePanel2);
                    }
                    if (vpnAllDevicePanel2.isEnabled()) {
                        vpnAllDevicePanel2.resetVpnList(2);
                    } else {
                        this.removePanel(vpnAllDevicePanel2);
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(" VpnDeviceList: having panel reset table failed ");
            return;
        }
    }

    public synchronized void resetAll() {
        try {
            int n = 0;
            while (n < this.panels.size()) {
                VpnAllDevicePanel vpnAllDevicePanel = (VpnAllDevicePanel)this.panels.elementAt(n);
                vpnAllDevicePanel.resetVpnList(1);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(" VpnDeviceList: having panel reset All Sections failed ");
            return;
        }
    }

    public boolean addDevice(VpnDevice vpnDevice) {
        boolean bl = true;
        try {
            bl = this.model.addDevice(vpnDevice);
            this.devices.addElement(vpnDevice);
        }
        catch (Exception exception) {
            System.out.println(" bad device");
            bl = false;
        }
        return bl;
    }

    public int addDevice(String string, String string2, String string3, String string4, int n, Integer n2, Integer n3, String string5) {
        VpnDevice vpnDevice;
        int n4 = 0;
        Enumeration enumeration = this.devices.elements();
        while (enumeration.hasMoreElements()) {
            vpnDevice = (VpnDevice)enumeration.nextElement();
            if (vpnDevice.name.equals(string)) {
                n4 = 1;
            }
            if (!vpnDevice.ipAddress.equals(string2)) continue;
            n4 = 2;
        }
        if (n4 == 0) {
            vpnDevice = new VpnDevice(string, string2, string3, string4, n, n2, n3, string5);
            this.devices.addElement(vpnDevice);
        }
        return n4;
    }

    public Vector getDeviceList() {
        return this.devices;
    }

    public int getNumDevices() {
        return this.devices.size();
    }

    public boolean nameFind(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.devices.size()) {
            VpnDevice vpnDevice = (VpnDevice)this.devices.elementAt(n);
            if (vpnDevice.name.equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public int listfind(String string, String string2, int n, int[] nArray) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = -5;
        int n3 = 0;
        int n4 = 0;
        if (string == null || string.length() == 0) {
            bl = false;
        } else {
            n3 = this.findCompareType(string);
            if (n3 == 5) {
                return -6;
            }
            string = this.test.toUpperCase();
            n2 = -2;
        }
        if (string2 == null || string2.length() == 0) {
            bl2 = false;
        } else {
            n4 = this.findCompareType(string2);
            if (n4 == 5) {
                return -7;
            }
            string2 = this.test.toUpperCase();
            n2 = -3;
        }
        if (bl && bl2) {
            bl3 = true;
            n2 = -4;
        }
        if (bl || bl2) {
            int n5 = n;
            while (n5 < this.devices.size()) {
                VpnDevice vpnDevice = (VpnDevice)this.devices.elementAt(nArray[n5]);
                if (bl3) {
                    if (this.myCompare(vpnDevice.name, string, n3) && this.myCompare(vpnDevice.ipAddress.toString(), string2, n4)) {
                        bl4 = true;
                    }
                } else {
                    if (bl && this.myCompare(vpnDevice.name, string, n3)) {
                        bl4 = true;
                    }
                    if (bl2 && n4 == 4) {
                        bl4 = vpnDevice.ipAddress.equals(string2);
                    } else if (bl2 && this.myCompare(vpnDevice.ipAddress.toString(), string2, n4)) {
                        bl4 = true;
                    }
                }
                if (bl4) {
                    n2 = nArray[n5];
                    break;
                }
                ++n5;
            }
        }
        return n2;
    }

    public int findCompareType(String string) {
        int n = 0;
        try {
            this.test = "fail";
            int n2 = string.indexOf(this.wildcard);
            if (n2 == string.length() - 1) {
                this.test = string.substring(0, n2);
                n = 1;
            } else if (n2 == 0) {
                this.test = string.substring(1, string.length());
                n2 = this.test.indexOf(this.wildcard);
                if (n2 == this.test.length() - 1) {
                    this.test = this.test.substring(0, n2);
                    n = 2;
                } else {
                    n = n2 == -1 ? 3 : 0;
                }
            } else if (n2 == -1) {
                this.test = string;
                n = 4;
            } else {
                n = 5;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println(" VpnDeviceList: error in searching device list");
            n = 0;
        }
        return n;
    }

    public boolean myCompare(String string, String string2, int n) {
        boolean bl = false;
        string = string.toUpperCase();
        switch (n) {
            case 1: {
                bl = string.startsWith(string2);
                break;
            }
            case 2: {
                if (string.indexOf(string2) <= -1) break;
                bl = true;
                break;
            }
            case 3: {
                bl = string.endsWith(string2);
                break;
            }
            case 4: {
                bl = string.equals(string2);
                break;
            }
        }
        return bl;
    }

    public VpnDevice getDeviceAt(int n) {
        return (VpnDevice)this.devices.elementAt(n);
    }

    public int deleteDeviceAt(int n) {
        int n2 = this.deleteDevice((VpnDevice)this.devices.elementAt(n));
        return n2;
    }

    public int deleteDevice(VpnDevice vpnDevice) {
        int n = 0;
        try {
            if (!this.model.deleteDevice(vpnDevice)) {
                n = 1;
            }
            if (n == 0 && !this.devices.removeElement(vpnDevice)) {
                n = 2;
            }
        }
        catch (Exception exception) {
            System.out.println("VpnDeviceList: unable to delete item from Device list");
            n = 1;
        }
        return n;
    }

    public int changeDevice(int n, VpnDevice vpnDevice, VpnDevice vpnDevice2) {
        int n2 = 0;
        try {
            if (!this.model.changeDevice(vpnDevice, vpnDevice2)) {
                n2 = 1;
            }
            if (n2 == 0) {
                this.devices.setElementAt(vpnDevice2, n);
            }
        }
        catch (Exception exception) {
            System.out.println("VpnDeviceList: unable to change item from Device list");
            n2 = 1;
        }
        return n2;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            try {
                string2 = commonResources.getString(string);
            }
            catch (Exception exception2) {
                string2 = string;
            }
        }
        return string2;
    }
}

